<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T18:03:25.768949055 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A710" />
    <supported-cpuid id="Cortex-X2" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions per Cycle (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexX2CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexX2INST_RETIRED / $InstructionsPerCycleCortexX2CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Cycle Accounting (Cortex-X2)">
        <series color="255,153,0" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexX2CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexX2STALL_FRONTEND / $FrontendStalledCyclesCortexX2CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexX2CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexX2STALL_BACKEND / $BackendStalledCyclesCortexX2CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Level 1 (Cortex-X2)">
        <series color="255,153,0" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexX2CPU_CYCLES &gt; 0), min(($BackendBoundCortexX2STALL_SLOT_BACKEND / (8 * $BackendBoundCortexX2CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
        <series color="0,102,255" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexX2CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexX2OP_SPEC &gt; 0), min(((1 - ($RetiringCortexX2STALL_SLOT / ($RetiringCortexX2CPU_CYCLES * 8))) * ($RetiringCortexX2OP_RETIRED / $RetiringCortexX2OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="General (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexX2OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexX2OP_RETIRED / $RetiredOperationsPercentageCortexX2OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexX2INST_RETIRED &gt; 0), (($BranchMPKICortexX2BR_MIS_PRED_RETIRED / $BranchMPKICortexX2INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexX2BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexX2BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexX2BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexX2INST_RETIRED &gt; 0), (($ITLBMPKICortexX2ITLB_WALK / $ITLBMPKICortexX2INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
        <series color="0,102,255" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexX2INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexX2L1I_TLB_REFILL / $L1InstructionTLBMPKICortexX2INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Instruction TLB Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexX2L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexX2ITLB_WALK / $ITLBWalkPercentageCortexX2L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexX2L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexX2L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexX2L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexX2INST_RETIRED &gt; 0), (($L1ICacheMPKICortexX2L1I_CACHE_REFILL / $L1ICacheMPKICortexX2INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction Cache Effectiveness (Frontend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexX2L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexX2L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexX2L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexX2INST_RETIRED &gt; 0), (($DTLBMPKICortexX2DTLB_WALK / $DTLBMPKICortexX2INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
        <series color="153,0,255" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexX2INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexX2L1D_TLB_REFILL / $L1DataTLBMPKICortexX2INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
        <series color="0,255,153" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexX2INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexX2L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexX2INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Data TLB Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexX2L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexX2DTLB_WALK / $DTLBWalkPercentageCortexX2L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexX2L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexX2L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexX2L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexX2L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexX2L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexX2L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexX2INST_RETIRED &gt; 0), (($L1DCacheMPKICortexX2L1D_CACHE_REFILL / $L1DCacheMPKICortexX2INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexX2L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexX2L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexX2L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexX2INST_RETIRED &gt; 0), (($L2CacheMPKICortexX2L2D_CACHE_REFILL / $L2CacheMPKICortexX2INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexX2L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexX2L2D_CACHE_REFILL / $L2CacheMissPercentageCortexX2L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexX2INST_RETIRED &gt; 0), (($L3CacheMPKICortexX2L3D_CACHE_REFILL / $L3CacheMPKICortexX2INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Unified Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexX2L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexX2L3D_CACHE_REFILL / $L3CacheMissPercentageCortexX2L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexX2INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexX2LL_CACHE_MISS_RD / $LLCacheReadMPKICortexX2INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
   </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Last Level Cache Effectiveness (Backend Stalled Cycles) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexX2LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexX2LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexX2LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexX2LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexX2LL_CACHE_RD - $LLCacheReadHitPercentageCortexX2LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexX2LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Topdown Backend (Backend Bound) (Cortex-X2)">
        <series color="255,153,0" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundCortexX2STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexX2STALL_BACKEND_MEM / $BackendMemoryBoundCortexX2STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexX2INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexX2ISB_SPEC + $BarrierOperationsPercentageCortexX2DSB_SPEC) + $BarrierOperationsPercentageCortexX2DMB_SPEC) / $BarrierOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
        <series color="255,0,102" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexX2INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexX2BR_IMMED_SPEC + $BranchOperationsPercentageCortexX2BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexX2INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexX2CRYPTO_SPEC / $CryptoOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexX2INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexX2DP_SPEC - $IntegerOperationsPercentageCortexX2DSB_SPEC) / $IntegerOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexX2INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexX2VFP_SPEC / $FloatingPointOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
        <series color="102,255,0" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexX2INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexX2ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
        <series color="128,77,0" description="This metric measures scalable vector operations, including loads and stores, as a percentage of operations speculatively executed" expression="if(($SVEOperationsLoadStoreInclusivePercentageCortexX2INST_SPEC &gt; 0), min(($SVEOperationsLoadStoreInclusivePercentageCortexX2SVE_INST_SPEC / $SVEOperationsLoadStoreInclusivePercentageCortexX2INST_SPEC), 1), 0)" name="SVE Operations (Load/Store Inclusive) Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageCortexX2INST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageCortexX2FP_HP_SPEC / $HalfPrecisionFloatingPointPercentageCortexX2INST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
        <series color="153,0,255" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageCortexX2INST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageCortexX2FP_SP_SPEC / $SinglePrecisionFloatingPointPercentageCortexX2INST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
        <series color="0,255,153" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageCortexX2INST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageCortexX2FP_DP_SPEC / $DoublePrecisionFloatingPointPercentageCortexX2INST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexX2INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexX2LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexX2INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexX2INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexX2STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexX2INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexX2INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexX2LD_SPEC / $LoadOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexX2INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexX2ST_SPEC / $StoreOperationsPercentageCortexX2INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
   </chart>
   <chart rendering_type="bar" series_composition="stacked" percentage="yes" title="Speculative Operation Mix (Retired Operations Percentage) (Cortex-X2)">
        <series color="255,153,0" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexX2INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexX2RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexX2INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
        <series color="0,102,255" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexX2INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexX2RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexX2INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
   </chart>
    <select-metric id="ARMv8_Cortex_A710_metric_backend_bound" />
    <select-metric id="ARMv8_Cortex_A710_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Cortex_A710_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A710_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp16_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp32_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_fp64_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A710_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A710_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A710_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A710_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Cortex_A710_metric_retiring" />
    <select-metric id="ARMv8_Cortex_A710_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_strex_percentage" />
    <select-metric id="ARMv8_Cortex_A710_metric_sve_all_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_backend_bound" />
    <select-metric id="ARMv8_Cortex_X2_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Cortex_X2_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_X2_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_fp16_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_fp32_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_fp64_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_X2_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_ipc" />
    <select-metric id="ARMv8_Cortex_X2_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X2_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_X2_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Cortex_X2_metric_retiring" />
    <select-metric id="ARMv8_Cortex_X2_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_strex_percentage" />
    <select-metric id="ARMv8_Cortex_X2_metric_sve_all_percentage" />
</template>
